/*! ColumnControl 1.2.0
 * Copyright (c) SpryMedia Ltd - datatables.net/license
 *
 * SVG icons: ISC License
 * Copyright (c) for portions of Lucide are held by Cole Bemis 2013-2022 as part of Feather (MIT).
 * All other copyright (c) for Lucide are held by Lucide Contributors 2022.
 */
import jQuery from"jquery";import DataTable from"datatables.net";let $=jQuery;function createElement(t,e,n,r){void 0===e&&(e=[]),void 0===n&&(n=null),void 0===r&&(r=[]);var o=document.createElement(t);return addClass(o,e),n&&(o.innerHTML=n),r.forEach(function(t){o.appendChild(t)}),o}function addClass(e,t){t&&(t=Array.isArray(t)?t:[t]).forEach(function(t){e&&t&&e.classList.add(t)})}function wrap(t){return'<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">'+t+"</svg>"}var icons={chevronRight:wrap('<path d="m9 18 6-6-6-6"/>'),columns:wrap('<rect width="18" height="18" x="3" y="3" rx="2"/><path d="M9 3v18"/><path d="M15 3v18"/>'),contains:wrap('<path d="M10 3h4v18h-4z"/><path d="M18 8h3v9h-3"/><path d="M6 17H3V8h3"/>'),empty:wrap('<circle cx="12" cy="12" r="10"/>'),ends:wrap('<path d="M21 3h-4v18h4z"/><path d="M13 8H3v9h10"/>'),equal:wrap('<line x1="5" x2="19" y1="9" y2="9"/><line x1="5" x2="19" y1="15" y2="15"/>'),greater:wrap('<path d="m9 18 6-6-6-6"/>'),greaterOrEqual:wrap('<path d="m9 16 6-6-6-6"/><path d="m9 21 6-6"/>'),groupAdd:wrap('<path d="M6 21v-7.5m-3.549 3.75H9.75"/><rect width="13.5" height="7.5" x="3" y="3" rx="1.5"/><rect width="7.5" height="7.5" x="13.5" y="13.5" fill="currentColor" rx="1.5"/>'),groupClear:wrap('<rect width="13.5" height="7.5" x="3" y="3" rx="1.5"/><rect width="7.5" height="7.5" x="13.5" y="13.5" rx="1.5"/>'),groupTop:wrap('<rect width="13.5" height="7.5" x="3" y="3" fill="currentColor" rx="1.5"/><rect width="7.5" height="7.5" x="13.5" y="13.5" rx="1.5"/>'),groupRemove:wrap('<path d="M2.451 17.25H9.75"/><rect width="13.5" height="7.5" x="3" y="3" rx="1.5"/><rect width="7.5" height="7.5" x="13.5" y="13.5" rx="1.5"/>'),less:wrap('<path d="m15 18-6-6 6-6"/>'),lessOrEqual:wrap('<path d="m15 16-6-6 6-6"/><path d="m15 21-6-6"/>'),menu:wrap('<line x1="4" x2="20" y1="12" y2="12"/><line x1="4" x2="20" y1="6" y2="6"/><line x1="4" x2="20" y1="18" y2="18"/>'),move:wrap('<line x1="12" x2="12" y1="3" y2="21"/><polyline points="8 8 4 12 8 16"/><polyline points="16 16 20 12 16 8"/>'),moveLeft:wrap('<path d="m9 6-6 6 6 6"/><path d="M3 12h14"/><path d="M21 19V5"/>'),moveRight:wrap('<path d="M3 5v14"/><path d="M21 12H7"/><path d="m15 18 6-6-6-6"/>'),notContains:wrap('<path d="M15 4 9 20"/><path d="M3 8h18v9H3z"/>'),notEmpty:wrap('<circle cx="12" cy="12" r="10"/><line x1="9" x2="15" y1="15" y2="9"/>'),notEqual:wrap('<path d="M5 9h14"/><path d="M5 15h14"/><path d="M15 5 9 19"/>'),orderAddAsc:wrap('<path d="M17 21v-8"/><path d="M3 4h6"/><path d="M3 8h9"/><path d="M3 12h10"/><path d="M13 17h8"/>'),orderAddDesc:wrap('<path d="M17 21v-8"/><path d="M3 4h12"/><path d="M3 8h9"/><path d="M3 12h6"/><path d="M13 17h8"/>'),orderAsc:wrap('<path d="m3 8 4-4 4 4"/><path d="M7 4v16"/><path d="M11 12h4"/><path d="M11 16h7"/><path d="M11 20h10"/>'),orderClear:wrap('<path d="m21 21-8-8"/><path d="M3 4h12"/><path d="M3 8h9"/><path d="M3 12h6"/><path d="m13 21 8-8"/>'),orderDesc:wrap('<path d="m3 16 4 4 4-4"/><path d="M7 20V4"/><path d="M11 4h10"/><path d="M11 8h7"/><path d="M11 12h4"/>'),orderRemove:wrap('<path d="M3 4h12"/><path d="M3 8h9"/><path d="M3 12h6"/><path d="M13 17h8"/>'),orderNone:wrap('<path d="m3 8 4-4 4 4"/><path d="m11 16-4 4-4-4"/><path d="M7 4v16"/><path d="M15 8h6"/><path d="M15 16h6"/><path d="M13 12h8"/>'),search:wrap('<circle cx="11" cy="11" r="8"/><path d="m21 21-4.3-4.3"/>'),searchClear:wrap('<path d="m13.5 8.5-5 5"/><path d="m8.5 8.5 5 5"/><circle cx="11" cy="11" r="8"/><path d="m21 21-4.3-4.3"/>'),starts:wrap('<path d="M3 3h4v18H3z"/><path d="M11 8h10v9H11"/>'),tick:wrap('<path d="M20 6 9 17l-5-5"/>'),x:wrap('<path d="M18 6 6 18"/><path d="m6 6 12 12"/>')};function close(e){void 0===e&&(e=null),document.querySelectorAll("div.dtcc-dropdown").forEach(function(t){null!==e&&t.contains(e.target)||(t._close(),e._closed||(e._closed=[]),e._closed.push(t))})}function getContainer(t,e){return e.closest("div.dtfh-floatingparent")||t.table().container()}function positionDropdown(t,e,n){var r=n.closest("div.dt-column-header"),e=getContainer(e,n),r=getComputedStyle(r),o=t.offsetWidth,i=relativePosition(e,n),a=i.top+n.offsetHeight,r="row-reverse"===r.flexDirection?i.left:i.left-o+n.offsetWidth,i=e.offsetWidth;i<r+o&&(r-=r+o-i),r<0&&(r=0),t.style.top=a+"px",t.style.left=r+"px"}function attachDropdown(n,t,e){function r(t){var e;n._shown?t.target===n||n.contains(t.target)||(e=document.querySelector("div.dt-datetime"))&&(t.target===e||e.contains(t.target))||(n._close(),document.body.removeEventListener("click",r)):document.body.removeEventListener("click",r)}var o=getContainer(t,e.element());n._shown=!0,o.append(n),positionDropdown(n,t,e.element()),e.element().setAttribute("aria-expanded","true");return document.body.addEventListener("click",r),r}function relativePosition(t,e){for(var n=0,r=0;e&&e!==t&&e!==document.body;)n+=e.offsetTop,r+=e.offsetLeft,e.scrollTop&&(r-=e.scrollTop),e.scrollLeft&&(r-=e.scrollLeft),e=e.offsetParent;return{top:n,left:r}}function focusCapture(r,o){return function(t){var e,n;r._shown&&(e=Array.from(r.querySelectorAll("a, button, input, select")),n=document.activeElement,"Escape"===t.key?(r._close(),o.focus()):"Tab"===t.key&&0!==e.length&&(e.includes(n)?t.shiftKey?n===e[0]&&(e[e.length-1].focus(),t.preventDefault()):n===e[e.length-1]&&(e[0].focus(),t.preventDefault()):(e[0].focus(),t.preventDefault())))}}var dropdownContent={classes:{container:"dtcc-dropdown",liner:"dtcc-dropdown-liner"},defaults:{className:"dropdown",content:[],icon:"menu",text:"More..."},init:function(n){var r=this.dt(),o=createElement("div",dropdownContent.classes.container,"",[createElement("div",dropdownContent.classes.liner)]),t=(o._shown=!1,o._close=function(){o.remove(),o._shown=!1,i.element().setAttribute("aria-expanded","false")},o.setAttribute("role","dialog"),o.setAttribute("aria-label",r.i18n("columnControl.dropdown",n.text)),r.on("fixedheader-mode",function(){o._shown&&attachDropdown(o,r,n._parents?n._parents[0]:i)}),o.childNodes[0]),i=new Button(r,this).text(r.i18n("columnControl.dropdown",n.text)).icon(n.icon).className(n.className).dropdownDisplay(t).handler(function(t){var e;t._closed&&t._closed.includes(o)||(attachDropdown(o,r,n._parents?n._parents[0]:i),(e=o.querySelector("input, a, button"))&&"keypress"===t.type&&e.focus())});i.element().setAttribute("aria-haspopup","dialog"),i.element().setAttribute("aria-expanded","false");for(var e=0;e<n.content.length;e++){var a=this.resolve(n.content[e]),a=(a.config._parents||(a.config._parents=[]),a.config._parents.push(i),a.plugin.init.call(this,a.config));t.appendChild(a)}n._parents&&n._parents.length&&i.extra("chevronRight"),r.on("columns-reordered",function(){positionDropdown(o,r,i.element())});var s=focusCapture(o,i.element());return document.body.addEventListener("keydown",s),r.on("destroy",function(){document.body.removeEventListener("keydown",s)}),i.element()}},_namespace=0,Button=(()=>{function n(t,e){this._s={active:!1,activeList:[],buttonClick:null,dt:null,enabled:!0,host:null,label:"",namespace:"",value:null},this._s.dt=t,this._s.host=e,this._dom={button:createElement("button",n.classes.container),dropdownDisplay:null,extra:createElement("span","dtcc-button-extra"),icon:createElement("span","dtcc-button-icon"),state:createElement("span","dtcc-button-state"),text:createElement("span","dtcc-button-text")},this._dom.button.setAttribute("type","button"),this._dom.button.append(this._dom.icon),this._dom.button.append(this._dom.text),this._dom.button.append(this._dom.state),this._dom.button.append(this._dom.extra),this.enable(!0)}return n.prototype.active=function(t){return void 0===t?this._s.active:(this._s.active=t,this._checkActive(),this)},n.prototype.activeList=function(t,e){return this._s.activeList[t]=e,this._checkActive(),this},n.prototype.checkDisplay=function(){for(var t=0,e=this._dom.dropdownDisplay.childNodes,n=0;n<e.length;n++)"none"!==e[n].style.display&&t++;return 0===t&&(this._dom.button.style.display="none"),this},n.prototype.className=function(t){return this._dom.button.classList.add("dtcc-button_"+t),this},n.prototype.destroy=function(){this._s.buttonClick&&(this._dom.button.removeEventListener("click",this._s.buttonClick),this._dom.button.removeEventListener("keypress",this._s.buttonClick)),this._s.host.destroyRemove(this)},n.prototype.dropdownDisplay=function(t){return this._dom.dropdownDisplay=t,this},n.prototype.element=function(){return this._dom.button},n.prototype.enable=function(t){return void 0===t?this._s.enabled:(this._dom.button.classList.toggle("dtcc-button_disabled",!t),this._s.enabled=t,this)},n.prototype.extra=function(t){return this._dom.extra.innerHTML=t?icons[t]:"",this},n.prototype.handler=function(e){function t(t){close(t),t.stopPropagation(),t.preventDefault(),n._s.enabled&&e(t)}var n=this;return this._s.buttonClick=t,this._s.namespace="dtcc-"+_namespace++,this._dom.button.addEventListener("click",t),this._dom.button.addEventListener("keypress",t),this._s.host.destroyAdd(this),this},n.prototype.icon=function(t){return this._dom.icon.innerHTML=t?icons[t]:"",this},n.prototype.text=function(t){return void 0===t?this._s.label:(this._dom.text.innerHTML=t,this._s.label=t,this._dom.button.setAttribute("aria-label",t),this)},n.prototype.value=function(t){return void 0===t?this._s.value:(this._s.value=t,this)},n.prototype._checkActive=function(){return!0===this._s.active||Object.values(this._s.activeList).includes(!0)?(this._dom.state.innerHTML=icons.tick,this._dom.button.classList.add("dtcc-button_active")):(this._dom.state.innerHTML="",this._dom.button.classList.remove("dtcc-button_active")),this},n.classes={container:"dtcc-button"},n})(),CheckList=(()=>{function c(t,e,n){function r(){a._s.search=s.search.value,a._redraw()}function o(t){a.selectAll(),a._s.handler(t,null,a._s.buttons,!0),a._updateCount()}function i(t){a.selectNone(),a._s.handler(t,null,a._s.buttons,!0),a._updateCount()}var a=this,s=(this._s={buttons:[],dt:null,handler:function(){},host:null,search:""},this._s.dt=t,this._s.host=e,this._dom={buttons:createElement("div","dtcc-list-buttons"),container:createElement("div",c.classes.container),controls:createElement("div","dtcc-list-controls"),empty:createElement("div","dtcc-list-empty",t.i18n("columnControl.list.empty","No options")),title:createElement("div","dtcc-list-title"),selectAll:createElement("button","dtcc-list-selectAll",t.i18n("columnControl.list.all","Select all")),selectAllCount:createElement("span"),selectNone:createElement("button","dtcc-list-selectNone",t.i18n("columnControl.list.none","Deselect")),selectNoneCount:createElement("span"),search:createElement("input",c.classes.input)},this._dom);s.search.setAttribute("type","text"),s.container.append(s.title),s.container.append(s.controls),s.container.append(s.empty),s.container.append(s.buttons),n.select&&(s.controls.append(s.selectAll),s.controls.append(s.selectNone),s.selectAll.append(s.selectAllCount),s.selectNone.append(s.selectNoneCount),s.selectAll.setAttribute("type","button"),s.selectNone.setAttribute("type","button"));n.search&&(s.controls.append(s.search),s.search.setAttribute("placeholder",t.i18n("columnControl.list.search","Search...")),s.search.addEventListener("input",r)),s.selectAll.addEventListener("click",o),s.selectNone.addEventListener("click",i),t.on("destroy",function(){s.selectAll.removeEventListener("click",o),s.selectNone.removeEventListener("click",i),s.search.removeEventListener("input",r)})}return c.prototype.add=function(n,t){for(var r=this,o=(Array.isArray(n)||(n=[n]),this),e=0;e<n.length;e++)(t=>{var t=n[t],e=new Button(o._s.dt,o._s.host).active(t.active||!1).handler(function(t){r._s.handler(t,e,r._s.buttons,!0),r._updateCount()}).icon(t.icon||"").text(""!==t.label?t.label:o._s.dt.i18n("columnControl.list.empty","Empty")).value(t.value);""===t.label&&e.className("empty"),o._s.buttons.push(e)})(e);var i=this._s.buttons.length;return!0!==t&&void 0!==t||(this._dom.selectAllCount.innerHTML=i?"("+i+")":"",this._redraw()),this},c.prototype.button=function(t){for(var e=this._s.buttons,n=0;n<e.length;n++)if(e[n].value()===t)return e[n];return null},c.prototype.clear=function(){for(var t=0;t<this._s.buttons.length;t++)this._s.buttons[t].destroy();return this._dom.buttons.replaceChildren(),this._s.buttons.length=0,this},c.prototype.element=function(){return this._dom.container},c.prototype.handler=function(t){return this._s.handler=t,this},c.prototype.searchListener=function(t){var n=this;return t.on("cc-search-clear",function(t,e){e===n._s.host.idx()&&(n.selectNone(),n._s.handler(t,null,n._s.buttons,!1),n._s.search="",n._dom.search.value="",n._redraw(),n._updateCount())}),this},c.prototype.selectAll=function(){for(var t=0;t<this._s.buttons.length;t++)this._s.buttons[t].active(!0);return this},c.prototype.selectNone=function(){for(var t=0;t<this._s.buttons.length;t++)this._s.buttons[t].active(!1);return this},c.prototype.title=function(t){return this._dom.title.innerHTML=t,this},c.prototype.values=function(t){var e,n=[],r=this._s.buttons;if(void 0!==t){for(e=0;e<r.length;e++)t.includes(r[e].value())&&r[e].active(!0);return this._updateCount(),this}for(e=0;e<r.length;e++)r[e].active()&&n.push(r[e].value());return n},c.prototype._updateCount=function(){var t=this.values().length;this._dom.selectNoneCount.innerHTML=t?"("+t+")":""},c.prototype._redraw=function(){var t=this._s.buttons,e=this._dom.buttons,n=this._s.search.toLowerCase();e.replaceChildren();for(var r=0;r<t.length;r++){var o=t[r];n&&!o.text().toLowerCase().includes(n)||e.appendChild(o.element())}this._dom.empty.style.display=0===t.length?"block":"none",e.style.display=0<t.length?"block":"none"},c.classes={container:"dtcc-list",input:"dtcc-list-search"},c})(),colVis={defaults:{className:"colVis",columns:"",search:!1,select:!1,title:"Column visibility"},init:function(t){function n(){o.columns(t.columns).every(function(){i.add({active:this.visible(),label:this.title(),value:this.index()})})}var o=this.dt(),i=new CheckList(o,this,{search:t.search,select:t.select}).title(o.i18n("columnControl.colVis",t.title)).handler(function(t,e,n){e&&e.active(!e.active()),r(n)}),r=function(t){for(var e=0;e<t.length;e++){var n=t[e],r=n.value(),r=o.column(r);n.active()&&!r.visible()?r.visible(!0):!n.active()&&r.visible()&&r.visible(!1)}};return n(),o.on("column-visibility",function(t,e,n,r){n=i.button(n);n&&n.active(r)}),o.on("columns-reordered",function(t,e){i.clear(),n()}),i.element()}},colVisDropdown={defaults:{className:"colVis",columns:"",search:!1,select:!1,text:"Column visibility",title:"Column visibility"},extend:function(t){return{extend:"dropdown",icon:"columns",text:this.dt().i18n("columnControl.colVisDropdown",t.text),content:[Object.assign(t,{extend:"colVis"})]}}},reorder={defaults:{className:"reorder",icon:"move",text:"Reorder columns"},init:function(t){var n=this,e=this.dt(),r=new Button(e,this).text(e.i18n("columnControl.reorder",t.text)).icon(t.icon).className(t.className);return 0===this.idx()&&r.enable(!1),e.on("columns-reordered",function(t,e){r.enable(0<n.idx())}),e.init().colReorder||new DataTable.ColReorder(e,{}),r.element()}},reorderLeft={defaults:{className:"reorderLeft",icon:"moveLeft",text:"Move column left"},init:function(t){var n=this,e=this.dt(),r=new Button(e,this).text(e.i18n("columnControl.reorderLeft",t.text)).icon(t.icon).className(t.className).handler(function(){var t=n.idx();0<t&&e.colReorder.move(t,t-1)});return 0===this.idx()&&r.enable(!1),e.on("columns-reordered",function(t,e){r.enable(0<n.idx())}),r.element()}},reorderRight={defaults:{className:"reorderRight",icon:"moveRight",text:"Move column right"},init:function(t){var n=this,r=this.dt(),o=new Button(r,this).text(r.i18n("columnControl.reorderRight",t.text)).icon(t.icon).className(t.className).handler(function(){var t=n.idx();t<r.columns().count()-1&&r.colReorder.move(t,t+1)});return this.idx()===r.columns().count()-1&&o.enable(!1),r.on("columns-reordered",function(t,e){o.enable(n.idx()<r.columns().count()-1)}),o.element()}},order={defaults:{className:"order",iconAsc:"orderAsc",iconDesc:"orderDesc",iconNone:"orderNone",statusOnly:!1,text:"Toggle ordering"},init:function(r){var o=this,t=this.dt(),i=new Button(t,this).text(t.i18n("columnControl.order",r.text)).icon("orderAsc").className(r.className);return r.statusOnly||t.order.listener(i.element(),DataTable.versionCheck("2.3.2")?function(){return[o.idx()]}:this.idx(),function(){}),t.on("order",function(t,e,n){n=n.find(function(t){return t.col===o.idx()});n?"asc"===n.dir?i.active(!0).icon(r.iconAsc):"desc"===n.dir&&i.active(!0).icon(r.iconDesc):i.active(!1).icon(r.iconNone)}),i.element()}},orderAddAsc={defaults:{className:"orderAddAsc",icon:"orderAddAsc",text:"Add Sort Ascending"},init:function(t){var r=this,e=this.dt(),o=new Button(e,this).text(e.i18n("columnControl.orderAddAsc",t.text)).icon(t.icon).className(t.className).handler(function(){e.order().push([r.idx(),"asc"]),e.draw()});return e.on("order",function(t,e,n){n=n.some(function(t){return t.col===r.idx()});o.enable(!n)}),o.element()}},orderAddDesc={defaults:{className:"orderAddDesc",icon:"orderAddDesc",text:"Add Sort Descending"},init:function(t){var r=this,e=this.dt(),o=new Button(e,this).text(e.i18n("columnControl.orderAddDesc",t.text)).icon(t.icon).className(t.className).handler(function(){e.order().push([r.idx(),"desc"]),e.draw()});return e.on("order",function(t,e,n){n=n.some(function(t){return t.col===r.idx()});o.enable(!n)}),o.element()}},orderAsc={defaults:{className:"orderAsc",icon:"orderAsc",text:"Sort Ascending"},init:function(t){var r=this,e=this.dt(),o=new Button(e,this).text(e.i18n("columnControl.orderAsc",t.text)).icon(t.icon).className(t.className).handler(function(){r.dt().order([{idx:r.idx(),dir:"asc"}]).draw()});return e.on("order",function(t,e,n){n=n.some(function(t){return t.col===r.idx()&&"asc"===t.dir});o.active(n)}),o.element()}},orderClear={defaults:{className:"orderClear",icon:"orderClear",text:"Clear sort"},init:function(t){var e=this.dt(),r=new Button(e,this).text(e.i18n("columnControl.orderClear",t.text)).icon(t.icon).className(t.className).handler(function(){e.order([]).draw()});return e.on("order",function(t,e,n){r.enable(0<n.length)}),0===e.order().length&&r.enable(!1),r.element()}},orderDesc={defaults:{className:"orderDesc",icon:"orderDesc",text:"Sort Descending"},init:function(t){var r=this,e=this.dt(),o=new Button(e,this).text(e.i18n("columnControl.orderDesc",t.text)).icon(t.icon).className(t.className).handler(function(){r.dt().order([{idx:r.idx(),dir:"desc"}]).draw()});return e.on("order",function(t,e,n){n=n.some(function(t){return t.col===r.idx()&&"desc"===t.dir});o.active(n)}),o.element()}},orderRemove={defaults:{className:"orderRemove",icon:"orderRemove",text:"Remove from sort"},init:function(t){var r=this,n=this.dt(),o=new Button(n,this).text(n.i18n("columnControl.orderRemove",t.text)).icon(t.icon).className(t.className).handler(function(){var t=n.order(),e=t.findIndex(function(t){return t[0]===r.idx()});t.splice(e,1),n.order(t).draw()});return n.on("order",function(t,e,n){n=n.some(function(t){return t.col===r.idx()});o.enable(n)}),o.enable(!1),o.element()}},orderStatus={defaults:{className:"order",iconAsc:"orderAsc",iconDesc:"orderDesc",iconNone:"orderNone",statusOnly:!0,text:"Sort status"},extend:function(t){return Object.assign(t,{extend:"order"})}};function rowGroupAdd$1(t,e){var n=rowGroupApplied(t);return-1===n.indexOf(e)&&(n.push(e),t.rowGroup().dataSrc(n)),n}function rowGroupApplied(t){t=t.rowGroup().dataSrc();return Array.isArray(t)?t:[t]}function rowGroupClear$1(t){t.rowGroup().dataSrc([])}function rowGroupRemove$1(t,e){var n=rowGroupApplied(t),e=n.indexOf(e);return-1!==e&&(n.splice(e,1),t.rowGroup().dataSrc(n)),n}var rowGroup={defaults:{className:"rowGroup",icon:"groupTop",order:!0,text:"Group rows"},init:function(e){var n=this,r=this.dt(),o=new Button(r,this).text(r.i18n("columnControl.rowGroup",e.text)).icon(e.icon).className(e.className).handler(function(){var t=r.column(n.idx()).dataSrc();o.active()?rowGroupRemove$1(r,t):(rowGroupClear$1(r),rowGroupAdd$1(r,t),!1!==e.order&&r.order([n.idx(),"asc"])),r.draw()});return r.on("rowgroup-datasrc",function(){var t=rowGroupApplied(r),e=r.column(n.idx()).dataSrc();o.active(t.includes(e))}),o.element()}},rowGroupAdd={defaults:{className:"rowGroupAdd",icon:"groupAdd",order:!0,text:"Add to grouping"},init:function(t){var n=this,r=this.dt(),o=new Button(r,this).text(r.i18n("columnControl.rowGroup",t.text)).icon(t.icon).className(t.className).handler(function(){var t=r.column(n.idx()).dataSrc();o.enable()&&rowGroupAdd$1(r,t),r.draw()});return r.on("rowgroup-datasrc",function(){var t=rowGroupApplied(r),e=r.column(n.idx()).dataSrc();o.enable(!t.includes(e))}),o.element()}},rowGroupClear={defaults:{className:"rowGroupClear",icon:"groupClear",text:"Clear all grouping"},init:function(t){var e=this.dt(),n=new Button(e,this).text(e.i18n("columnControl.rowGroup",t.text)).icon(t.icon).className(t.className).handler(function(){rowGroupClear$1(e),e.draw()});return e.on("rowgroup-datasrc",function(){n.enable(0<rowGroupApplied(e).length)}),n.enable(0<rowGroupApplied(e).length),n.element()}},rowGroupRemove={defaults:{className:"rowGroupRemove",icon:"groupRemove",order:!0,text:"Remove from grouping"},init:function(t){var n=this,r=this.dt(),o=new Button(r,this).text(r.i18n("columnControl.rowGroup",t.text)).icon(t.icon).className(t.className).handler(function(){var t=r.column(n.idx()).dataSrc();o.enable()&&(rowGroupRemove$1(r,t),r.draw())});return r.on("rowgroup-datasrc",function(){var t=rowGroupApplied(r),e=r.column(n.idx()).dataSrc();o.enable(t.includes(e))}),o.enable(!1),o.element()}},SearchInput=(()=>{function c(n,t){function e(){i.runSearch()}function r(){a.typeIcon.innerHTML=icons[a.select.value],i.runSearch()}function o(){i.clear()}var i=this,a=(this._type="text",this._sspTransform=null,this._sspData={},this._dt=n,this._idx=t,this._dom={clear:createElement("span","dtcc-search-clear",icons.x),container:createElement("div",c.classes.container),typeIcon:createElement("div","dtcc-search-type-icon"),searchIcon:createElement("div","dtcc-search-icon",icons.search),input:createElement("input",c.classes.input),inputs:createElement("div"),select:createElement("select",c.classes.select),title:createElement("div","dtcc-search-title")},this._dom),s=t;a.input.setAttribute("type","text"),a.container.append(a.title,a.inputs),a.inputs.append(a.typeIcon,a.select,a.searchIcon,a.clear,a.input);a.input.addEventListener("input",e),a.select.addEventListener("input",r),a.clear.addEventListener("click",o),n.on("destroy",function(){a.input.removeEventListener("input",e),a.select.removeEventListener("input",r),a.clear.removeEventListener("click",o)}),n.on("stateSaveParams.DT",function(t,e,n){n.columnControl||(n.columnControl={}),n.columnControl[i._idx]||(n.columnControl[i._idx]={}),n.columnControl[i._idx].searchInput={logic:a.select.value,type:i._type,value:a.input.value}}),n.on("stateLoaded.DT",function(t,e,n){i._stateLoad(n)}),n.on("columns-reordered.DT",function(t,e){i._idx=n.colReorder.transpose(s,"fromOriginal")}),n.on("cc-search-clear.DT",function(t,e){e===i._idx&&(i._loadingState=!0,i.clear(),i._loadingState=!1)}),n.page.info().serverSide&&n.on("preXhr.DT",function(t,e,n){var r;n.columns&&n.columns[i._idx]&&(n.columns[i._idx].columnControl||(n.columns[i._idx].columnControl={}),r=i._dom.input.value,i._sspTransform&&(r=i._sspTransform(r)),n.columns[i._idx].columnControl.search=Object.assign({value:r,logic:i._dom.select.value,type:i._type},i._sspData))})}return c.prototype.addClass=function(t){return this._dom.container.classList.add(t),this},c.prototype.clear=function(){return this.set(this._dom.select.children[0].getAttribute("value"),""),this},c.prototype.clearable=function(t){return t||this._dom.clear.remove(),this},c.prototype.element=function(){return this._dom.container},c.prototype.input=function(){return this._dom.input},c.prototype.options=function(t){for(var e=this._dom.select,n=0;n<t.length;n++)e.add(new Option(t[n].label,t[n].value));return this._dom.typeIcon.innerHTML=icons[t[0].value],this},c.prototype.placeholder=function(t){var e;return t&&(e=this._dt.column(this._idx).title(),this._dom.input.placeholder=t.replace("[title]",e)),this},c.prototype.runSearch=function(){var t=this._dom,e="empty"===t.select.value||"notEmpty"===t.select.value||""!==t.input.value;t.container.classList.toggle("dtcc-search_active",e),!this._search||this._lastValue===t.input.value&&this._lastType===t.select.value||(this._search(t.select.value,t.input.value,this._loadingState),this._lastValue=t.input.value,this._lastType=t.select.value)},c.prototype.search=function(t){return this._search=t,this._stateLoad(this._dt.state.loaded()),this},c.prototype.set=function(t,e){var n=this._dom;return n.input.value=e,n.select.value=t,n.typeIcon.innerHTML=icons[n.select.value],this.runSearch(),this},c.prototype.sspTransform=function(t){return this._sspTransform=t,this},c.prototype.sspData=function(t){return this._sspData=t,this},c.prototype.title=function(t){var e;return t&&(e=this._dt.column(this._idx).title(),this._dom.title.innerHTML=t.replace("[title]",e)),this},c.prototype.titleAttr=function(t){var e;return t&&(e=this._dt.column(this._idx).title(),this._dom.input.title=t.replace("[title]",e)),this},c.prototype.type=function(t){return this._type=t,this},c.prototype._stateLoad=function(t){var e=this._dom,n=this._idx,n=null==(t=null==(t=null==t?void 0:t.columnControl)?void 0:t[n])?void 0:t.searchInput;n&&(this._loadingState=!0,e.select.value=n.logic,e.input.value=n.value,e.select.dispatchEvent(new Event("input")),this._loadingState=!1)},c.classes={container:["dtcc-content","dtcc-search"],input:"",select:""},c})(),searchDateTime={defaults:{clear:!0,excludeLogic:[],format:"",mask:"",placeholder:"",title:"",titleAttr:""},init:function(a){var s,c=this,l=!1,u=DataTable.use("moment"),d=DataTable.use("luxon"),h=this.dt(),t="columnControl.search.datetime.",p="",m="",e=new SearchInput(h,this.idx()).type("date").addClass("dtcc-searchDateTime").sspTransform(function(t){return toISO(t,p,u,d)}).sspData({mask:a.mask}).clearable(a.clear).placeholder(a.placeholder).title(a.title).titleAttr(a.titleAttr).options([{label:h.i18n(t+"equal","Equals"),value:"equal"},{label:h.i18n(t+"notEqual","Does not equal"),value:"notEqual"},{label:h.i18n(t+"greater","After"),value:"greater"},{label:h.i18n(t+"less","Before"),value:"less"},{label:h.i18n(t+"empty","Empty"),value:"empty"},{label:h.i18n(t+"notEmpty","Not empty"),value:"notEmpty"}].filter(function(t){return!a.excludeLogic.includes(t.value)})).search(function(e,n,t){a._parents&&a._parents.forEach(function(t){return t.activeList(c.unique(),"empty"===e||"notEmpty"===e||!!n)});var r=h.column(c.idx());if(h.page.info().serverSide)r.init().__ccList=!("empty"!==e&&"notEmpty"!==e&&!n),t||h.draw();else{var o=a.mask,i=""===n?"":dateToNum(s&&l?s.val():n.trim(),p,u,d,o);if("empty"===e)r.search.fixed("dtcc",function(t){return!t});else if("notEmpty"===e)r.search.fixed("dtcc",function(t){return!!t});else{if(""===r.search.fixed("dtcc")&&""===i)return;i?"equal"===e?r.search.fixed("dtcc",function(t){return dateToNum(t,m,u,d,o)==i}):"notEqual"===e?r.search.fixed("dtcc",function(t){return dateToNum(t,m,u,d,o)!=i}):"greater"===e?r.search.fixed("dtcc",function(t){return dateToNum(t,m,u,d,o)>i}):"less"===e&&r.search.fixed("dtcc",function(t){return dateToNum(t,m,u,d,o)<i}):r.search.fixed("dtcc","")}t||r.draw()}});return h.ready(function(){var t=DataTable.use("datetime");m=getFormat(h,c.idx()),p=a.format||m,t&&(s=new t(e.input(),{format:p,i18n:h.settings()[0].oLanguage.datetime,onChange:function(){l=!0,e.runSearch(),l=!1}}))}),e.element()}};function getFormat(t,e){var n=t.column(e).type();if(n)if("datetime"===n){t=t.settings()[0].aoColumns[e].mRender,e=t("1999-08-07T23:05:04Z","display"),t=t("1999-08-07T03:05:04Z","display").includes("03");if(DataTable.use("moment"))return e.replace("23",t?"HH":"H").replace("11",t?"hh":"h").replace("05","mm").replace("04","ss").replace("PM","A").replace("pm","a").replace("07","DD").replace("7","D").replace("08","MM").replace("8","M").replace("1999","YYYY").replace("99","YY");if(DataTable.use("luxon"))return e.replace("23",t?"HH":"H").replace("11",t?"hh":"h").replace("05","mm").replace("04","ss").replace("PM","a").replace("07","dd").replace("7","d").replace("08","MM").replace("8","M").replace("1999","yyyy").replace("99","yy");if(e.includes("23")&&e.includes("1999"))return"YYYY-MM-DD hh:mm:ss";if(e.includes("23"))return"hh:mm:ss"}else{if(n.includes("datetime-"))return n.replace(/datetime-/g,"");if(n.includes("moment"))return n.replace(/moment-/g,"");if(n.includes("luxon"))return n.replace(/luxon-/g,"")}return"YYYY-MM-DD"}function dateToNum(t,e,n,r,o){return""===t?"":(n=t instanceof Date?t:"YYYY-MM-DD"!==e&&(n||r)?new Date(n?1e3*n(t,e).unix():r.DateTime.fromFormat(t,e).toMillis()):new Date(t.replace(/\//g,"-")),o&&(o.includes("YYYY")||n.setFullYear(1970),o.includes("MM")||n.setUTCMonth(0),o.includes("DD")||n.setUTCDate(1),o.includes("hh")||n.setUTCHours(0),o.includes("mm")||n.setUTCMinutes(0),o.includes("ss")||n.setUTCSeconds(0),o.includes("sss")||n.setUTCMilliseconds(0)),n.getTime())}function toISO(t,e,n,r){return""===t?"":"YYYY-MM-DD"!==e&&n?n.utc(t,e).toISOString():"YYYY-MM-DD"!==e&&r?r.DateTime.fromFormat(t,e).toISO():t.replace(/\//g,"-")}function setOptions(t,e){var n=t.values();t.clear();for(var r=0;r<e.length;r++)"object"==typeof e[r]?t.add({active:!1,label:e[r].label,value:e[r].value},r===e.length-1):t.add({active:!1,label:e[r],value:e[r]},r===e.length-1);n.length&&t.values(n)}function getState(t,e){t=null==(e=null==(e=null==e?void 0:e.columnControl)?void 0:e[t])?void 0:e.searchList;if(t)return t}function getJsonOptions(t,e){var n=null==(n=t.ajax.json())?void 0:n.columnControl,t=t.column(e),r=t.name(),t=t.dataSrc();return n&&n[r]?n[r]:n&&"string"==typeof t&&n[t]?n[t]:n&&n[e]?n[e]:null}function reloadOptions(t,e,n,r,o){var i=null==(i=t.ajax.json())?void 0:i.columnControl,a=[],s=getJsonOptions(t,n);if(s)a=s;else{if(i&&e.ajaxOnly)return void(e.hidable&&(r.element().style.display="none",e._parents)&&e._parents.forEach(function(t){return t.checkDisplay()}));if(!t.page.info().serverSide)for(var c={},l=t.rows({order:n}).indexes().toArray(),u=t.settings()[0],d=0;d<l.length;d++){var h=u.fastData(l[d],n,"filter"),h=null!=h?h.toString():"";c[h]||(c[h]=!0,a.push({label:u.fastData(l[d],n,e.orthogonal),value:h}))}}setOptions(r,a),o&&r.values(o)}var searchList={defaults:{ajaxOnly:!0,className:"searchList",hidable:!0,options:null,orthogonal:"display",search:!0,select:!0,title:""},init:function(r){function o(e){r._parents&&r._parents.forEach(function(t){return t.activeList(i.unique(),e&&!!e.length)});var t=s.column(i.idx());s.page.info().serverSide?t.init().__ccList=e&&0!==e.length:e&&(0===e.length?t.search.fixed("dtcc-list",""):t.search.fixed("dtcc-list",function(t){return e.includes(t)}))}var i=this,a=null,s=this.dt(),c=new CheckList(s,this,{search:r.search,select:r.select}).searchListener(s).title(s.i18n("columnControl.searchList",r.title).replace("[title]",s.column(this.idx()).title())).handler(function(t,e,n,r){e&&e.active(!e.active()),o(c.values()),r&&s.draw()}),l=(r.options?setOptions(c,r.options):(s.ready(function(){reloadOptions(s,r,i.idx(),c,a)}),s.on("xhr",function(t,e,n){s.one("draw",function(){reloadOptions(s,r,i.idx(),c,a),a=null})})),[]);return s.page.info().serverSide&&s.on("preXhr.DT",function(t,e,n){var r;n.columns&&n.columns[i.idx()]&&(n.columns[i.idx()].columnControl||(n.columns[i.idx()].columnControl={}),r=l.length?l:c.values(),l=[],n.columns[i.idx()].columnControl.list=Object.assign({},r))}),s.on("stateLoaded",function(t,e,n){n=getState(i.idx(),n);n&&(c.values(n),o(n))}),s.on("stateSaveParams",function(t,e,n){var r=i.idx();n.columnControl||(n.columnControl={}),n.columnControl[r]||(n.columnControl[r]={}),n.columnControl[r].searchList=s.ready()?c.values():a}),s.settings()[0].aoColumns[this.idx()].columnControlSearchList=function(t){"refresh"===t?reloadOptions(s,r,i.idx(),c,null):setOptions(c,t)},a=getState(this.idx(),s.state.loaded()),o(a),s.page.info().serverSide&&a&&a.length&&(l=a),c.element()}},searchNumber={defaults:{clear:!0,excludeLogic:[],placeholder:"",title:"",titleAttr:""},init:function(o){var i=this,a=this.dt(),t="columnControl.search.number.",t=new SearchInput(a,this.idx()).type("num").addClass("dtcc-searchNumber").clearable(o.clear).placeholder(o.placeholder).title(o.title).titleAttr(o.titleAttr).options([{label:a.i18n(t+"equal","Equals"),value:"equal"},{label:a.i18n(t+"notEqual","Does not equal"),value:"notEqual"},{label:a.i18n(t+"greater","Greater than"),value:"greater"},{label:a.i18n(t+"greaterOrEqual","Greater or equal"),value:"greaterOrEqual"},{label:a.i18n(t+"less","Less than"),value:"less"},{label:a.i18n(t+"lessOrEqual","Less or equal"),value:"lessOrEqual"},{label:a.i18n(t+"empty","Empty"),value:"empty"},{label:a.i18n(t+"notEmpty","Not empty"),value:"notEmpty"}].filter(function(t){return!o.excludeLogic.includes(t.value)})).search(function(e,n,t){o._parents&&o._parents.forEach(function(t){return t.activeList(i.unique(),"empty"===e||"notEmpty"===e||!!n)});var r=a.column(i.idx());if(a.page.info().serverSide)r.init().__ccList=!("empty"!==e&&"notEmpty"!==e&&!n),t||a.draw();else{if("empty"===e)r.search.fixed("dtcc",function(t){return!t});else if("notEmpty"===e)r.search.fixed("dtcc",function(t){return!!t});else{if(""===r.search.fixed("dtcc")&&""===n)return;""===n?r.search.fixed("dtcc",""):"equal"===e?r.search.fixed("dtcc",function(t){return stringToNum(t)==n}):"notEqual"===e?r.search.fixed("dtcc",function(t){return stringToNum(t)!=n}):"greater"===e?r.search.fixed("dtcc",function(t){return stringToNum(t)>n}):"greaterOrEqual"===e?r.search.fixed("dtcc",function(t){return stringToNum(t)>=n}):"less"===e?r.search.fixed("dtcc",function(t){return stringToNum(t)<n}):"lessOrEqual"===e&&r.search.fixed("dtcc",function(t){return stringToNum(t)<=n})}t||r.draw()}});return t.input().setAttribute("inputmode","numeric"),t.input().setAttribute("pattern","[0-9]*"),t.element()}},_re_html=/<([^>]*>)/g,_re_formatted_numeric=/['\u00A0,$£€¥%\u2009\u202F\u20BD\u20a9\u20BArfkɃΞ]/gi;function stringToNum(t){var e;return 0===t||t&&"-"!==t?"number"==(e=typeof t)||"bigint"==e?t:+(t=t.replace?t.replace(_re_html,"").replace(_re_formatted_numeric,""):t):-1/0}var searchText={defaults:{clear:!0,excludeLogic:[],placeholder:"",title:"",titleAttr:""},init:function(o){var i=this,a=this.dt(),t="columnControl.search.text.";return new SearchInput(a,this.idx()).addClass("dtcc-searchText").clearable(o.clear).placeholder(o.placeholder).title(o.title).titleAttr(o.titleAttr).options([{label:a.i18n(t+"contains","Contains"),value:"contains"},{label:a.i18n(t+"notContains","Does not contain"),value:"notContains"},{label:a.i18n(t+"equal","Equals"),value:"equal"},{label:a.i18n(t+"notEqual","Does not equal"),value:"notEqual"},{label:a.i18n(t+"starts","Starts"),value:"starts"},{label:a.i18n(t+"ends","Ends"),value:"ends"},{label:a.i18n(t+"empty","Empty"),value:"empty"},{label:a.i18n(t+"notEmpty","Not empty"),value:"notEmpty"}].filter(function(t){return!o.excludeLogic.includes(t.value)})).search(function(e,n,t){o._parents&&o._parents.forEach(function(t){return t.activeList(i.unique(),"empty"===e||"notEmpty"===e||!!n)});var r=a.column(i.idx());if(a.page.info().serverSide)r.init().__ccList=!("empty"!==e&&"notEmpty"!==e&&!n),t||a.draw();else{if(n=n.toLowerCase(),"empty"===e)r.search.fixed("dtcc",function(t){return!t});else if("notEmpty"===e)r.search.fixed("dtcc",function(t){return!!t});else{if(""===r.search.fixed("dtcc")&&""===n)return;""===n?r.search.fixed("dtcc",""):"equal"===e?r.search.fixed("dtcc",function(t){return t.toLowerCase()==n}):"notEqual"===e?r.search.fixed("dtcc",function(t){return t.toLowerCase()!=n}):"contains"===e?r.search.fixed("dtcc",n):"notContains"===e?r.search.fixed("dtcc",function(t){return!t.toLowerCase().includes(n)}):"starts"===e?r.search.fixed("dtcc",function(t){return t.toLowerCase().startsWith(n)}):"ends"===e&&r.search.fixed("dtcc",function(t){return t.toLowerCase().endsWith(n)})}o._parents&&o._parents.forEach(function(t){return t.activeList(i.unique(),!!r.search.fixed("dtcc"))}),t||r.draw()}}).element()}},search={defaults:{allowSearchList:!1},init:function(n){function e(t){var e=getJsonOptions(i,a);return"list"===t||n.allowSearchList&&e?searchList.init.call(o,Object.assign({},searchList.defaults,n)):"date"===t||t.startsWith("datetime")?searchDateTime.init.call(o,Object.assign({},searchDateTime.defaults,n)):t.includes("num")?searchNumber.init.call(o,Object.assign({},searchNumber.defaults,n)):searchText.init.call(o,Object.assign({},searchText.defaults,n))}var r,o=this,i=this.dt(),a=this.idx(),t=null==(t=null==(t=i.state.loaded())?void 0:t.columnControl)?void 0:t[a];return t?t.searchInput?r=e(t.searchInput.type):t.searchList&&(r=e("list")):(r=document.createElement("div"),i.ready(function(){var t=i.column(a),t=e(t.type());r.replaceWith(t)})),r}},searchClear$1={defaults:{className:"searchClear",icon:"searchClear",text:"Clear Search"},init:function(t){var o=this,i=this.dt(),a=new Button(i,this).text(i.i18n("columnControl.searchClear",t.text)).icon(t.icon).className(t.className).handler(function(){i.column(o.idx()).columnControl.searchClear().draw()}).enable(!1);return i.on("draw",function(){var t=i.column(o.idx()),e=t.search.fixed("dtcc"),n=t.search.fixed("dtcc-list"),r=t.init().__ccSearch,t=t.init().__ccList;a.enable(!!(e||n||r||t))}),a.element()}},searchDropdown={defaults:{ajaxOnly:!0,allowSearchList:!0,className:"searchDropdown",clear:!0,columns:"",hidable:!0,options:null,orthogonal:"display",placeholder:"",search:!0,select:!0,text:"Search",title:"",titleAttr:""},extend:function(t){return{extend:"dropdown",icon:"search",text:this.dt().i18n("columnControl.searchDropdown",t.text),content:[Object.assign(t,{extend:"search"})]}}},spacer={defaults:{className:"dtcc-spacer",text:""},init:function(t){var e=this.dt(),e=createElement("div",t.className,e.i18n("columnControl.spacer",t.text));return e.setAttribute("role","separator"),e}},title={defaults:{className:"dtcc-title",text:null},init:function(t){var e=this.dt().column(this.idx()).title(),n=null===t.text?"[title]":t.text;return createElement("div",t.className,n.replace("[title]",e))}},contentTypes={colVis:colVis,colVisDropdown:colVisDropdown,dropdown:dropdownContent,reorder:reorder,reorderLeft:reorderLeft,reorderRight:reorderRight,rowGroup:rowGroup,rowGroupAdd:rowGroupAdd,rowGroupClear:rowGroupClear,rowGroupRemove:rowGroupRemove,order:order,orderAddAsc:orderAddAsc,orderAddDesc:orderAddDesc,orderAsc:orderAsc,orderClear:orderClear,orderDesc:orderDesc,orderRemove:orderRemove,orderStatus:orderStatus,search:search,searchClear:searchClear$1,searchDropdown:searchDropdown,searchDateTime:searchDateTime,searchList:searchList,searchNumber:searchNumber,searchText:searchText,spacer:spacer,title:title},ColumnControl=(()=>{function i(n,t,e){var r=this,o=(this._dom={target:null,wrapper:null},this._c={},this._s={columnIdx:null,unique:null,toDestroy:[]},this._dt=n,this._s.columnIdx=t,this._s.unique=Math.random(),t);Object.assign(this._c,i.defaults,e),this._dom.target=this._target(),e.className&&addClass(this._dom.target.closest("tr"),e.className),this._c.content&&(n.on("columns-reordered",function(t,e){r._s.columnIdx=n.colReorder.transpose(o,"fromOriginal")}),this._dom.wrapper=document.createElement("span"),this._dom.wrapper.classList.add("dtcc"),this._dom.target.appendChild(this._dom.wrapper),this._c.content.forEach(function(t){t=r.resolve(t),t=t.plugin.init.call(r,t.config);r._dom.wrapper.appendChild(t)}),n.on("destroy",function(){r._s.toDestroy.slice().forEach(function(t){t.destroy()}),r._dom.wrapper.remove()}))}return i.prototype.destroyAdd=function(t){this._s.toDestroy.push(t)},i.prototype.destroyRemove=function(t){t=this._s.toDestroy.indexOf(t);-1!==t&&this._s.toDestroy.splice(t,1)},i.prototype.dt=function(){return this._dt},i.prototype.idx=function(){return this._s.columnIdx},i.prototype.resolve=function(t){var e=null,n=null,r=null;if("string"==typeof t?(e=i.content[r=t],n=Object.assign({},null==e?void 0:e.defaults)):Array.isArray(t)?(e=i.content[r="dropdown"],n=Object.assign({},null==e?void 0:e.defaults,{content:t})):t.extend&&(r=t.extend,e=i.content[r],n=Object.assign({},null==e?void 0:e.defaults,t)),e)return e.extend?(t=e.extend.call(this,n),this.resolve(t)):{config:n,type:r,plugin:e};throw new Error("Unknown ColumnControl content type: "+r)},i.prototype.unique=function(){return this._s.unique},i.prototype._target=function(){var t,e,n=this._c.target,r=this._dt.column(this._s.columnIdx),o="header";return"number"==typeof n?t=r.header(n):(e="tfoot"!==(n=n.split(":"))[0],n=n[1]?parseInt(n[1]):0,e?t=r.header(n):(t=r.footer(n),o="footer")),t.querySelector("div.dt-column-"+o)},i.Button=Button,i.CheckList=CheckList,i.SearchInput=SearchInput,i.content=contentTypes,i.defaults={className:"",content:null,target:0},i.icons=icons,i.version="1.2.0",i})();function searchClear(){var n=this;return this.iterator("column",function(t,e){n.trigger("cc-search-clear",[e])})}function assetTarget(t,e,n){if(!t[e]){var r=!0,o=0,i=("number"==typeof e?o=e:("tfoot"===(i=e.split(":"))[0]&&(r=!1),i[1]&&(o=parseInt(i[1]))),r?n.table().header():n.table().footer());if(!i.querySelectorAll("tr")[o]){var a=n.columns().count(),s=createElement("tr");s.setAttribute("data-dt-order","disable");for(var c=0;c<a;c++)s.appendChild(createElement("td"));i.appendChild(s)}t[e]=!0}}function getOptionsForTarget(t,e){var n=ColumnControl.defaults.target;if(isIContentArray(e)){if(n===t)return{target:n,content:e}}else if(Array.isArray(e))for(var r=0;r<e.length;r++){var o=e[r];if(isIContentArray(o)){if(n===t)return{target:n,content:o}}else if(isIConfig(o)){if(t===(void 0!==o.target?o.target:n))return o}else if(t===n)return{target:n,content:e}}else if("object"==typeof e)if(isIConfig(e)){if(t===(void 0!==e.target?e.target:n))return e}else if(t===n)return{target:n,content:e}}function identifyTargets(e,t){function n(t){e.includes(t)||e.push(t)}return Array.isArray(t)?0===t.length?n(ColumnControl.defaults.target):t.forEach(function(t){n(("object"==typeof t&&void 0!==t.target?t:ColumnControl.defaults).target)}):"object"==typeof t&&n((void 0!==t.target?t:ColumnControl.defaults).target),e}function isIConfig(t){return"object"==typeof t&&void 0!==t.target}function isIContentArray(t){var e=!1;if(!Array.isArray(t))return!1;for(var n=0;n<t.length;n++)if(isIConfig(t[n])){e=!0;break}return!e}DataTable.ColumnControl=ColumnControl,$(document).on("i18n.dt",function(t,e){if("dt"===t.namespace){var n=new DataTable.Api(e),t=n.table().header(),r=e.oInit.columnControl,o=ColumnControl.defaults,i=[],a={};t.querySelectorAll("tr").length<=1&&null===e.titleRow&&(e.titleRow=0),identifyTargets(i,r),ColumnControl.defaults.content&&identifyTargets(i,o),n.columns().every(function(t){var e=this.init().columnControl;identifyTargets(i,e)});for(var s=0;s<i.length;s++)assetTarget(a,i[s],n)}}),$(document).on("preInit.dt",function(t,e){var s,c,l,u;"dt"===t.namespace&&(s=new DataTable.Api(e),c=e.oInit.columnControl,l=ColumnControl.defaults,identifyTargets(u=[],c),ColumnControl.defaults.content&&identifyTargets(u,l),s.columns().every(function(t){for(var e=this.init().columnControl,n=identifyTargets(u.slice(),e),r=0;r<n.length;r++){var o=getOptionsForTarget(n[r],e),i=getOptionsForTarget(n[r],c),a=getOptionsForTarget(n[r],l);(a||i||o)&&new ColumnControl(s,this.index(),Object.assign({},a||{},i||{},o||{}))}}))}),DataTable.Api.registerPlural("columns().columnControl.searchClear()","column().columnControl.searchClear()",searchClear),DataTable.Api.registerPlural("columns().ccSearchClear()","column().ccSearchClear()",searchClear),DataTable.Api.registerPlural("columns().columnControl.searchList()","column().columnControl.searchList()",function(n){return this.iterator("column",function(t,e){t=t.aoColumns[e].columnControlSearchList;t&&t(n)})}),DataTable.ext.buttons.ccSearchClear={text:function(t){return t.i18n("columnControl.buttons.searchClear","Clear search")},init:function(n,t,e){var r=this;n.on("draw.DT",function(){var t=!1,e=!!n.search();e||n.columns().every(function(){(this.search.fixed("dtcc")||this.search.fixed("dtcc-list"))&&(t=!0)}),r.enable(e||t)}),this.enable(!1)},action:function(t,e,n,r){e.search(""),e.columns().columnControl.searchClear(),e.draw()}};export default DataTable;